package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TareaOS3DaoImpl;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TareaOS3DaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TareaOS3CustomDaoImpl extends TareaOS3DaoImpl
		implements TareaOS3CustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_096 IDTAREA096, t1.MAILBOX_TASK_ID_096 MAILBOXTASKID096, t1.TIPO_TAREA_096 TIPOTAREA096, t1.ESTADO_096 ESTADO096, t1.FECHA_INI_096 FECHAINI096, t1.FECHA_FIN_096 FECHAFIN096, t1.USUARIO_096 USUARIO096, t1.ID_TRAMITE_096 IDTRAMITE096, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090 FROM VTAREAS_OS3 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TareaOS3> rwMap = new RowMapper<TareaOS3>() {
		public TareaOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TareaOS3 tarea = new TareaOS3(resultSet.getLong("IDTAREA096"),
					resultSet.getString("MAILBOXTASKID096"), null,
					resultSet.getLong("ESTADO096"),
					resultSet.getDate("FECHAINI096"),
					resultSet.getDate("FECHAFIN096"),
					resultSet.getString("USUARIO096"),
					new TramiteOS3(resultSet.getLong("IDTRAMITE096")));

			tarea.setTipoTarea(new Tarea(resultSet.getLong("TIPOTAREA096"),
					new Tramite(resultSet.getLong("IDTRAMITE090")),
					resultSet.getString("TASKID090"),
					resultSet.getString("DESCRIPCIONES090"),
					resultSet.getString("DESCRIPCIONEU090"),
					resultSet.getBoolean("ESINICIAL090"),
					resultSet.getString("TIPO090")));

			return tarea;
		}
	};

	/**
	 * Finds a single row in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  TareaOS3
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the tarea OS 3
	 */
	@Transactional(readOnly = true)
	public TareaOS3 vfind(TareaOS3 tareaOS3) {
		StringBuilder query = new StringBuilder(
				TareaOS3CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_096 = ? ");

		List<TareaOS3> tareaOS3List = this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, tareaOS3.getIdTarea096());
		return (TareaOS3) DataAccessUtils.uniqueResult(tareaOS3List);
	}

	/**
	 * Finds a list of rows in the TareaOS3 table.
	 * 
	 *  tareaOS3
	 *            TareaOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaOS3>
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TareaOS3> vfindAll(TareaOS3 tareaOS3,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TareaOS3CustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tareaOS3);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.FECHA_INI_096 DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TareaOS3>) this.getJdbcTemplate().query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TareaOS3 entity
	 * 
	 *  tareaOS3
	 *            TareaOS3 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tareaOS3 the tarea OS 3
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TareaOS3 tareaOS3) {

		StringBuilder where = new StringBuilder(
				TareaOS3CustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tareaOS3 != null && tareaOS3.getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_096 = ?");
			params.add(tareaOS3.getIdTarea096());
		}
		if (tareaOS3 != null && tareaOS3.getTramiteOS3() != null
				&& tareaOS3.getTramiteOS3().getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_096 = ?");
			params.add(tareaOS3.getTramiteOS3().getIdTramite095());
		}
		if (tareaOS3 != null && tareaOS3.getMailboxTaskId096() != null) {
			where.append(" AND t1.MAILBOX_TASK_ID_096 = ?");
			params.add(tareaOS3.getMailboxTaskId096());
		}
		if (tareaOS3 != null && tareaOS3.getEstado096() != null) {
			where.append(" AND t1.ESTADO_096 = ?");
			params.add(tareaOS3.getEstado096());
		}
		if (tareaOS3 != null && tareaOS3.getFechaIni096() != null) {
			where.append(" AND t1.FECHA_INI_096 = ?");
			params.add(tareaOS3.getFechaIni096());
		}
		if (tareaOS3 != null && tareaOS3.getFechaFin096() != null) {
			where.append(" AND t1.FECHA_FIN_096 = ?");
			params.add(tareaOS3.getFechaFin096());
		}
		if (tareaOS3 != null && tareaOS3.getUsuario096() != null) {
			where.append(" AND t1.USUARIO_096 = ?");
			params.add(tareaOS3.getUsuario096());
		}

		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getIdTarea090() != null) {
			where.append(" AND t1.TIPO_TAREA_096 = ?");
			params.add(tareaOS3.getTipoTarea().getIdTarea090());
		}
		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getTramite() != null
				&& tareaOS3.getTipoTarea().getTramite()
						.getIdTramite089() != null) {
			where.append(" AND t1.ID_TRAMITE_090 = ?");
			params.add(tareaOS3.getTipoTarea().getTramite().getIdTramite089());
		}
		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getTaskId090() != null) {
			where.append(" AND t1.TASK_ID_090 = ?");
			params.add(tareaOS3.getTipoTarea().getTaskId090());
		}
		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getDescripcionEs090() != null) {
			where.append(" AND t1.DESCRIPCION_ES_090 = ?");
			params.add(tareaOS3.getTipoTarea().getDescripcionEs090());
		}
		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getDescripcionEu090() != null) {
			where.append(" AND t1.DESCRIPCION_EU_090 = ?");
			params.add(tareaOS3.getTipoTarea().getDescripcionEu090());
		}
		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.ES_INICIAL_090 = ?");
			params.add(tareaOS3.getTipoTarea().getEsInicial090());
		}
		if (tareaOS3 != null && tareaOS3.getTipoTarea() != null
				&& tareaOS3.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.TIPO_090 = ?");
			params.add(tareaOS3.getTipoTarea().getEsInicial090());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
